/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.datafixers.util.Either;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.connect.MineTogetherConnect;
import net.creeperhost.minetogether.lib.web.ApiClientResponse;
import net.creeperhost.minetogether.orderform.OrderForm;
import net.creeperhost.minetogether.serverlist.MineTogetherServerList;
import net.creeperhost.minetogether.serverlist.data.Server;
import net.creeperhost.minetogether.serverlist.web.GetServerRequest;
import net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.minetogether.session.MineTogetherSession;
import net.creeperhost.polylib.client.screen.ButtonHelper;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MineTogetherClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ExecutorService SESSION_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MT Session Executor").build());
    private static boolean first = true;
    @Nullable
    private static MineTogetherSession session;

    public static void init() {
        LOGGER.info("Initializing MineTogetherClient!");
        Minecraft mc = Minecraft.m_91087_();
        GameProfile profile = mc.m_91094_().m_92548_();
        if (profile.getId() != null && profile.getId().version() == 4) {
            session = new MineTogetherSession(Path.of("./.mtsession", new String[0]), profile.getId(), profile.getName(), () -> {
                String serverId = Hashing.sha1().hashString((CharSequence)UUID.randomUUID().toString(), StandardCharsets.UTF_8).toString();
                try {
                    mc.m_91108_().joinServer(mc.m_91094_().m_92548_(), mc.m_91094_().m_92547_(), serverId);
                    return serverId;
                }
                catch (AuthenticationException ex) {
                    LOGGER.error("Failed to send 'joinServer' request.", (Throwable)ex);
                    return null;
                }
            });
        }
        MineTogetherChat.init();
        MineTogetherServerList.init();
        OrderForm.init();
        MineTogetherConnect.init();
        ClientGuiEvent.INIT_POST.register(MineTogetherClient::onScreenOpen);
    }

    public static CompletableFuture<Either<JWebToken, String>> getSession() {
        if (session == null) {
            return CompletableFuture.completedFuture(Either.right((Object)"Offline mode. No session available."));
        }
        if (session.isValid()) {
            return CompletableFuture.completedFuture(Either.left((Object)session.getToken()));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                session.validate();
                if (!session.isValid()) {
                    LOGGER.error("Got invalid session after validate.. Api failure?");
                    return Either.right((Object)"Got invalid session after validate.. Api failure?");
                }
                return Either.left((Object)session.getToken());
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to validate session.", ex);
                return Either.right((Object)"Failed to acquire session token. See logs.");
            }
        }, SESSION_EXECUTOR);
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        if (screen instanceof TitleScreen && first) {
            Server server;
            first = false;
            String serverProp = System.getProperty("mt.server");
            if (serverProp == null) {
                return;
            }
            try {
                ApiClientResponse<GetServerRequest.Response> resp = MineTogether.API.execute(new GetServerRequest(serverProp));
                if (resp.apiResponse().getStatus().equals("error")) {
                    LOGGER.error("Failed to load server with id: {}. Message: {}", (Object)serverProp, (Object)resp.apiResponse().getMessageOrNull());
                    return;
                }
                server = resp.apiResponse().server;
                if (server == null) {
                    LOGGER.error("Returned empty server?");
                    return;
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to query server.", (Throwable)ex);
                return;
            }
            ServerData serverData = new ServerData(server.ip, String.valueOf(server.port), false);
            ConnectScreen.m_169267_((Screen)new JoinMultiplayerScreen(screen), (Minecraft)Minecraft.m_91087_(), (ServerAddress)ServerAddress.m_171864_((String)serverData.f_105363_), (ServerData)serverData);
        } else if (screen instanceof PauseScreen) {
            List children = screen.m_6702_();
            List renderables = screenAccess.getRenderables();
            List narratables = screenAccess.getNarratables();
            Button bugs = ButtonHelper.findButton((String)"menu.reportBugs", (Screen)screen);
            if (bugs != null && Config.instance().issueTrackerUrl != null) {
                Button ourBugsButton = new Button(bugs.f_93620_, bugs.f_93621_, bugs.m_5711_(), bugs.m_93694_(), (Component)new TranslatableComponent("menu.reportBugs"), button -> {
                    String s = Config.instance().issueTrackerUrl;
                    Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(p_213069_2_ -> {
                        if (p_213069_2_) {
                            Util.m_137581_().m_137646_(s);
                        }
                        Minecraft.m_91087_().m_91152_(screen);
                    }, s, true));
                });
                children.set(children.indexOf(bugs), ourBugsButton);
                renderables.set(renderables.indexOf(bugs), ourBugsButton);
                narratables.set(narratables.indexOf(bugs), ourBugsButton);
                bugs = ourBugsButton;
            }
        }
    }
}

